function [isInside] = check_internal_points(P,Dom)
% CHECK_INTERNAL_POINTS stabilisce se un punto è all'interno di un poligono
% Scritto da Pavan Andrea - 18/02/2022
%       [isInside] = check_internal_points(P,D)
% INPUT:
%       P: punto [x y]
%       Dom: dominio poligonale chiuso [x(:) y(:)]
% OUTPUT:
%       isInside: booleano true se punto interno, false se esterno

D = Dom;
if norm(D(end,:)-D(1,:))>2*eps
    D = [D; D(1,:)];
end

isInside = false;
count = 0;
for i=1:length(D)-1
    if (D(i,1)-P(1))*(D(i+1,1)-P(1))<=0
        yint = interp1([D(i,1) D(i+1,1)],[D(i,2) D(i+1,2)],P(1));
        if P(2)<=yint
            count = count+1;
        end
    end
end

if mod(count,2)==1
    isInside = true;
end

end
